/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* $Id: opsdeclare.c,v 1.43 2001/10/01 14:43:31 dcraft Exp $
 *
 * $Log: opsdeclare.c,v $
 * Revision 1.43  2001/10/01 14:43:31  dcraft
 * Allow compiling portability layer for 2.4.7-10
 *
 * Revision 1.42  2001/09/22 20:08:06  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.41  2001/08/09 21:11:22  dcraft
 * Modifications to allow running on latest Redhat 7.1 update
 * Kernel version 2.4.3-12.
 * Requires checkout of new site.mcr.proto
 *
 * Revision 1.40  2001/08/04 00:42:27  tee
 * Remove LINUX_MMAP ifdefs
 *
 * Revision 1.39  2001/07/19 23:25:03  dcraft
 * Modified linux trace to allow non blocking trace record
 * writes (format is TRACE?N).  New gpfs swapd process created
 * which is responsible for reclaiming inodes (5 percent every
 * time it runs).  Marked all our inodes so that they would be
 * ignored by linux kswapd.  Added "unused" inode to inode
 * cache that could be used as a signal that linux kswapd is
 * running and kick off gpfs swapd.  Added means to ignore attempts
 * to kill mmfsd by kswapd if the system gets low on memory.
 * All done in an attempt to avoid kswapd premature wakeup on simple
 * locks and mutexes.
 *
 * Revision 1.38  2001/05/16 20:17:28  eshel
 * Define lookup operation only for directory files. LINUX determines if a file
 * is a directory or not base on the availability of this lookup operation in
 * the struct inode_operations.
 *
 * Revision 1.37  2001/05/12 18:38:27  schmuck
 * Fix problem with NFS returning spurious errors under load.
 *
 * Revision 1.36  2001/05/08 13:40:38  dixonbp
 * kxRegisterCleanup for linux and gpfs_f_cleanup/gpfsCleanup
 * to do the equivalent of what fopClose does on aix.
 *
 * Revision 1.35  2001/05/04 23:30:13  schmuck
 * Move "extern struct xxx_operations ..." declarations into .h file
 * instead of replicating them in various .c files.
 * Replace empty gpfs_dops_valid table with a NULL pointer.
 *
 * Revision 1.34  2001/05/04 14:49:17  wyllie
 * Remove gpfs_d_iput, since it only did an iput enclosed in traces.  As of
 * Linux kernel version 2.4.2, gpfs_d_iput should have done an iput_free()
 * anyway.
 *
 * Revision 1.33  2001/05/02 20:41:04  gjertsen
 * Modify use of daemon_fops to reflect "recent" changes in Linux kernel.
 *
 * Revision 1.32  2001/05/02 00:21:24  schmuck
 * Fix another problem found by tortureDir test on Linux:
 * On lookup and create, instantiate the dcache entry while holding the
 * inode lock, or, in case of a negative dcache entry, the directory lock.
 * This closes a window where a token revoke could clear the
 * CO_VFS_REFERENCE flag without invalidating the dcache entry.
 * It also eliminates the need for a d_revalidate operation.
 *
 * Revision 1.31  2001/04/24 18:13:21  wyllie
 * Hack to get this to compile with 2.4.0 header files
 *
 * Revision 1.30  2001/04/23 21:09:41  radhak
 * Defect 337635:
 * When deleting an inode, the cxiFreeOSNode() is setting
 * inode->i_mapping->a_ops pointer to NULL causing segmentation in
 * truncate_list_inode_pages() while cleaning mmaped pages.
 *
 * Revision 1.29  2001/04/11 21:05:00  schmuck
 * Remove gpfs_s_put_inode (this only called gpfsRele, and since put_inode is
 * always called while i_count is still non-zero, gpfsRele doesn't do anything).
 * Define TraceBKL to be a no-op when compiling without VERBOSETRACE.
 *
 * Revision 1.28  2001/04/04 21:14:44  dcraft
 * Invalidate inode attributes (particularly i_nlink) when getVattr() can no longer
 * find inode.   Update attributes after rename over an existing file, so d_move
 * will correctly kill target dentry.   Add printing of dentries when "mmfsadm dump vnodes"
 * is executed.  Initial implementation of gpfs_d_revalidate.
 *
 * Revision 1.27  2001/04/03 17:21:38  eshel
 * Add delete_inode() to mark inode for destruction when on last linux iput() call.
 *
 * Revision 1.26  2001/03/13 21:42:20  radhak
 * Defect 332458,333008:
 * need to register vm_ops->open function for incrementing mmap reference
 * count for every child process forked after mmap.
 *
 * Revision 1.25  2001/03/05 23:28:12  dcraft
 * Modify inode and gpfsNode reference management.  Inode is now acquired
 * during gpfsNode creation and must be released via cxiPutOSNode().
 * (documented in gpfs database).  Add "mmfsadm dump vnodes" for producing
 * trace info on all held inodes.
 *
 * Revision 1.24  2001/02/08 18:03:40  schmuck
 * Tweak fast path through gpfs_i_permission for files that don't have
 * extended acls: instead of doing the check in gpfs_i_permission,
 * set inode_operations::permission to NULL so Linux will do the check
 * without invoking gpfs_i_permission.
 * No functional change.
 *
 * Revision 1.23  2001/01/19 20:55:16  radhak
 * LINUX_MMAP: linux 2.4.0 kernel rework.
 * For time being disabled single node mmap symantics because of lack of
 * interface to invalidate memory mapped pages
 *
 * Revision 1.22  2000/12/29 22:22:36  radhak
 * Defect 322452: Before calling gpfs_filemap_sync get lock.
 * Also added some traces.
 *
 * Revision 1.21  2000/12/15 13:56:47  gjertsen
 * Clean up documentation.
 *
 */

#include <Shark-gpl.h>

/* Linux headers */
#include <linux/module.h>
#include <linux/mm.h> /* vm operations */

/* GPFS headers */
#include <linux2gpfs.h>

/* These structure definitions exist in this .c file
 * because gcc will do implicit structure initialization
 * (to null) for unnamed fields in c files.  This doesn't
 * work as nicely for C++
 */

struct super_operations gpfs_sops =
{
  read_inode:    gpfs_s_read_inode,
  read_inode2:   gpfs_s_read_inode2,
  write_inode:   NULL,
  delete_inode:  gpfs_s_delete_inode,
  put_super:     gpfs_s_put_super,        /* unmount (not force) */
  write_super:   gpfs_s_write_super,      /* sync */
  statfs:        gpfs_s_statfs,           /* statfs */
  remount_fs:    NULL,
  clear_inode:   gpfs_s_clear_inode,      /* inode completely unused */
  umount_begin:  gpfs_s_umount_begin,     /* unmount (force) */
};
DECLARE_FSTYPE_DEV(gpfs_fs_type, "gpfs", gpfs_read_super);

struct super_operations swapd_sops =
{
  read_inode:  swapd_s_read_inode,
  clear_inode: swapd_s_clear_inode,
};
  
struct file_operations daemon_fops =
{
  release: mmfsd_release,
};

struct file_operations gpfs_cleanup_fops =
{
  release: gpfs_f_cleanup
};

struct inode_operations daemon_inodeops;

/* Inode operations for non-symlinks, non-directory with standard Unix
   permissions (no extended acls) and valid inode attributes (valid owner and
   mode cached in the Linux inode structure). */
struct inode_operations gpfs_iops_stdperm =
{
  create:      gpfs_i_create,
// lookup:     no lookup op for non-directory
  link:        gpfs_i_link,
  unlink:      gpfs_i_unlink,
  symlink:     gpfs_i_symlink,
  mkdir:       gpfs_i_mkdir,
  rmdir:       gpfs_i_rmdir,
  mknod:       gpfs_i_mknod,
  rename:      gpfs_i_rename,
  readlink:    gpfs_i_readlink,
  truncate:    gpfs_i_truncate,   /* noop (done by setattr) */
//  permission:  use default permission checking code
  revalidate:  gpfs_i_revalidate,
  setattr:     gpfs_i_setattr,
  getattr:     gpfs_i_getattr
};

/* Inode operations for non-symlinks, non-directory that require a gpfs call
   to do permission checking either because the file/dir has extended acls or
   because the owner and mode cached in the Linux inode structure are not
   known to be valid. */
struct inode_operations gpfs_iops_xperm =
{
  create:      gpfs_i_create,
// lookup:     no lookup op for non-directory
  link:        gpfs_i_link,
  unlink:      gpfs_i_unlink,
  symlink:     gpfs_i_symlink,
  mkdir:       gpfs_i_mkdir,
  rmdir:       gpfs_i_rmdir,
  mknod:       gpfs_i_mknod,
  rename:      gpfs_i_rename,
  readlink:    gpfs_i_readlink,
  truncate:    gpfs_i_truncate,   /* noop (done by setattr) */
  permission:  gpfs_i_permission,
  revalidate:  gpfs_i_revalidate,
  setattr:     gpfs_i_setattr,
  getattr:     gpfs_i_getattr
};

/* Inode operations for directory with standard Unix permissions
   (no extended acls) and valid inode attributes (valid owner and mode
   cached in the Linux inode structure). */
struct inode_operations gpfs_dir_iops_stdperm =
{
  create:      gpfs_i_create,
  lookup:      gpfs_i_lookup,
  link:        gpfs_i_link,
  unlink:      gpfs_i_unlink,
  symlink:     gpfs_i_symlink,
  mkdir:       gpfs_i_mkdir,
  rmdir:       gpfs_i_rmdir,
  mknod:       gpfs_i_mknod,
  rename:      gpfs_i_rename,
  readlink:    gpfs_i_readlink,
  truncate:    gpfs_i_truncate,   /* noop (done by setattr) */
//  permission:  use default permission checking code
  revalidate:  gpfs_i_revalidate,
  setattr:     gpfs_i_setattr,
  getattr:     gpfs_i_getattr
};

/* Inode operations for directory that require a gpfs call to do permission
   checking either because the file/dir has extended acls or because the owner
   and mode cached in the Linux inode structure are not known to be valid. */
struct inode_operations gpfs_dir_iops_xperm =
{
  create:      gpfs_i_create,
  lookup:      gpfs_i_lookup,
  link:        gpfs_i_link,
  unlink:      gpfs_i_unlink,
  symlink:     gpfs_i_symlink,
  mkdir:       gpfs_i_mkdir,
  rmdir:       gpfs_i_rmdir,
  mknod:       gpfs_i_mknod,
  rename:      gpfs_i_rename,
  readlink:    gpfs_i_readlink,
  truncate:    gpfs_i_truncate,   /* noop (done by setattr) */
  permission:  gpfs_i_permission,
  revalidate:  gpfs_i_revalidate,
  setattr:     gpfs_i_setattr,
  getattr:     gpfs_i_getattr
};

/* inode operations for symlinks */
struct inode_operations gpfs_link_iops =
{
  create:       gpfs_i_create,     /* create             */
// lookup:      no lookup op for symlink
  link:         gpfs_i_link,       /* link               */
  unlink:       gpfs_i_unlink,     /* remove             */
  symlink:      gpfs_i_symlink,    /* symlink            */
  mkdir:        gpfs_i_mkdir,      /* mkdir              */
  rmdir:        gpfs_i_rmdir,      /* rmdir              */
  mknod:        gpfs_i_mknod,      /* mknod              */
  rename:       gpfs_i_rename,     /* rename             */
  readlink:     gpfs_i_readlink,   /* readlink           */
  follow_link:  gpfs_i_follow_link,/* readlink...      */
  truncate:     gpfs_i_truncate,   /* noop (done by setattr) */
  permission:   gpfs_i_permission, /* access             */
  revalidate:   gpfs_i_revalidate, /* getattr            */
  setattr:      gpfs_i_setattr,    /* setattr */
  getattr:      gpfs_i_getattr     /* getattr */
};

/* Default file operations, the other operations for the device
 * come from the bare device
 */
struct file_operations gpfs_fops =
{
  llseek:     gpfs_f_llseek,
  read:       gpfs_f_read,
  write:      gpfs_f_write,
  readdir:    gpfs_f_readdir,
  poll:       gpfs_f_poll,               /* ENOSYS */
  ioctl:      gpfs_f_ioctl,              /* ENOSYS */
  mmap:       gpfs_f_mmap,               /* ENOSYS */
  open:       gpfs_f_open,
  release:    gpfs_f_release,
  fsync:      gpfs_f_fsync,
  fasync:     gpfs_f_fasync,
  lock:       gpfs_f_lock,
  readv:      gpfs_f_readv,
  writev:     gpfs_f_writev
};

/* Directory file operations are the same as regular file operations, but
   read (as opposed to readdir) is not allowed */
struct file_operations gpfs_dir_fops =
{
  llseek:     gpfs_f_llseek,
  read:       gpfs_f_dir_read,
  write:      gpfs_f_write,
  readdir:    gpfs_f_readdir,
  poll:       gpfs_f_poll,               /* ENOSYS */
  ioctl:      gpfs_f_ioctl,              /* ENOSYS */
  mmap:       gpfs_f_mmap,               /* ENOSYS */
  open:       gpfs_f_open,
  release:    gpfs_f_release,
  fsync:      gpfs_f_fsync,
  fasync:     gpfs_f_fasync,
  lock:       gpfs_f_lock,
  readv:      gpfs_f_readv,
  writev:     gpfs_f_writev
};

/* dcache operations for a valid dentry:
   A valid dentry has no gpfs-specific operations defined;
   linux2gpfs.h #defines gpfs_dops_valid so that the assignement
   "d_op = &gpfs_dops_valid" will assign NULL to d_op instead of
   assigning a pointer to a table that only contains NULL function
   pointers.  This saves a few instructions on each potential call
   to one of the d_op callbacks.  The declaration below is left here
   ifdef'ed out so that a search for gpfs_dops_valid will find our
   comment here. */
#if 0
struct dentry_operations gpfs_dops_valid = { };
#endif

/* dcache operations for a valid dentry for a file that has been or will
   be unlinked shortly; a BR token revoke on the directory containing this
   entry should invalidate this entry even if it does not look like a
   negative dcache entry yet (call to d_delete has not yet happened);
   see also comment in gpfs_i_unlink.  */
struct dentry_operations gpfs_dops_ddeletepending =
{
  /* No operations defined.  There are explicit tests in the code for
     "d_op == &gpfs_dops_ddeletepending", so this structure cannot be
     removed as gpfs_dops_valid was. */
};

/* dcache operations for a dentry that has been invalidated by an inode
   token revoke on the file that this dentry refers to, or (in case of
   a negative dcache entry) by a BR token revoke on the directory
   containing this entry */
struct dentry_operations gpfs_dops_invalid =
{
  d_revalidate: gpfs_d_invalid,	
};

/* The other operations for the device come from the bare device */
struct block_device_operations gpfs_bops = 
{
  open:       gpfs_b_open,
  release:    gpfs_b_release,
  ioctl:      gpfs_b_ioctl,
  check_media_change: gpfs_b_check_media_change,
  revalidate: gpfs_b_revalidate,
};

struct file_operations gpfs_fbps = 
{
  open:    gpfs_fb_open,
  release: gpfs_fb_release,
  ioctl:   gpfs_fb_ioctl,
  read:    gpfs_fb_read,
  write:   gpfs_fb_write,
};

static struct address_space_operations gpfs_aops =
{
  readpage:       gpfs_i_readpage,
  writepage:      gpfs_i_writepage,
};

/* address_space_operations after inode deletion.
   truncatepage is called from truncate_list_pages when cleaning inodes.
*/
static struct address_space_operations gpfs_aops_after_inode_delete =
{
#if LINUX_KERNEL_VERSION >= 02040200 && LINUX_KERNEL_VERSION < 2040710
  truncatepage:   gpfs_i_truncatepage,
#endif
};

/*
 * filemap nopage callback function
 */
static
struct vm_operations_struct gpfs_vmop = 
{
  nopage:  gpfs_filemap_nopage,
  open:    gpfs_filemap_open,
  close:   gpfs_filemap_close,
};
